package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.service.CoordinadorObraService;
import com.ejie.ab04b.util.ValidadorNifCifNie;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * CoordinadorObraController generated by UDA, 20-feb-2017 12:41:55.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/coodinadorObra")
public class CoordinadorObraController {

	private static final Logger logger = LoggerFactory
			.getLogger(CoordinadorObraController.class);

	@Autowired()
	private CoordinadorObraService coordinadorObra;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 * binder WebDataBinder
	 *
	 * @param binder
	 *            the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * terexp084 String anoexp084 String numexp084 Integer tipcrd084 String
	 * tipdoc084 String numdoc084 String fecalt084 Date
	 *
	 * @param terexp084
	 *            the terexp 084
	 * @param anoexp084
	 *            the anoexp 084
	 * @param numexp084
	 *            the numexp 084
	 * @param tipcrd084
	 *            the tipcrd 084
	 * @param tipdoc084
	 *            the tipdoc 084
	 * @param numdoc084
	 *            the numdoc 084
	 * @param fecalt084
	 *            the fecalt 084 CoordinadorObra Objeto correspondiente al
	 *            identificador indicado.
	 * @return the coordinador obra
	 */
	@RequestMapping(value = "/{terexp084}/{anoexp084}/{numexp084}/{tipcrd084}/{tipdoc084}/{numdoc084}/{fecalt084}", method = RequestMethod.GET)
	public @ResponseBody() CoordinadorObra get(@PathVariable() String terexp084,
			@PathVariable() String anoexp084, @PathVariable() Integer numexp084,
			@PathVariable() String tipcrd084, @PathVariable() String tipdoc084,
			@PathVariable() String numdoc084, @PathVariable() Date fecalt084) {
		CoordinadorObra ab0484s00 = new CoordinadorObra();
		ab0484s00.setTerexp084(terexp084);
		ab0484s00.setAnoexp084(anoexp084);
		ab0484s00.setNumexp084(numexp084);
		ab0484s00.setTipcrd084(tipcrd084);
		ab0484s00.setTipdoc084(tipdoc084);
		ab0484s00.setNumdoc084(numdoc084);
		ab0484s00.setFecalt084(fecalt084);
		ab0484s00 = this.coordinadorObra.find(ab0484s00);
		CoordinadorObraController.logger
				.info("[GET - findBy_PK] : Obtener CoordinadorObra por PK");
		return ab0484s00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * filterCoordinadorObra CoordinadorObra Objeto que contiene los parametros
	 * de filtrado utilizados en la busqueda.
	 *
	 * @param filterCoordinadorObra
	 *            the filter coordinador obra List<CoordinadorObra> Lista de
	 *            objetos correspondientes a la busqueda realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<CoordinadorObra> getAll(
			@ModelAttribute() CoordinadorObra filterCoordinadorObra) {
		CoordinadorObraController.logger
				.info("[GET - find_ALL] : Obtener CoordinadorObra por filtro");
		return this.coordinadorObra.findAll(filterCoordinadorObra, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * ab0484s00 CoordinadorObra Bean que contiene la informacion a modificar.
	 *
	 * @param ab0484s00
	 *            the ab 0484 s 00 CoordinadorObra Bean resultante de la
	 *            modificacion.
	 * @return the coordinador obra
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() CoordinadorObra edit(
			@RequestBody() CoordinadorObra ab0484s00) {
		CoordinadorObra ab0484s00Aux = this.coordinadorObra.update(ab0484s00);
		CoordinadorObraController.logger
				.info("[PUT] : CoordinadorObra actualizado correctamente");
		return ab0484s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * ab0484s00 CoordinadorObra Bean que contiene la informacion con la que se
	 * va a crear el nuevo registro.
	 *
	 * @param ab0484s00
	 *            the ab 0484 s 00 CoordinadorObra Bean resultante del proceso
	 *            de creacion.
	 * @return the coordinador obra
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() CoordinadorObra add(
			@RequestBody() CoordinadorObra ab0484s00) {
		CoordinadorObra ab0484s00Aux = this.coordinadorObra.add(ab0484s00);
		CoordinadorObraController.logger
				.info("[POST] : CoordinadorObra insertado correctamente");
		return ab0484s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * ab0484s00 CoordinadorObra Bean que contiene la informacion con la que se
	 * va a crear el nuevo registro. request HttpServletRequest
	 *
	 * @param ab0484s00
	 *            the ab 0484 s 00
	 * @param request
	 *            the request CoordinadorObra Bean resultante del proceso de
	 *            creacion.
	 * @return the coordinador obra
	 */
	@RequestMapping(value = "coordinadorP", method = RequestMethod.POST)
	public @ResponseBody() CoordinadorObra addCoordinadorP(
			@RequestBody() CoordinadorObra ab0484s00,
			HttpServletRequest request) {

		CoordinadorObra ab0484s00Aux = new CoordinadorObra();

		HttpSession session = request.getSession();
		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null) {
				ab0484s00.setTerexp084(comunicAperturaSess.getTerape056());
				ab0484s00.setAnoexp084(comunicAperturaSess.getAnoape056());
				ab0484s00.setNumexp084(
						comunicAperturaSess.getNumape056().intValue());
				if (comunicAperturaSess.getCodobra056() != null) {
					ab0484s00
							.setCodobra084(comunicAperturaSess.getCodobra056());
				}
			}

		}

		// Validate
		List<ErrorField> errores = this.validateEditAdd(ab0484s00);
		if (errores != null && !errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// Mirar que ese coordinador no este asignado ya
		CoordinadorObra coordFind = new CoordinadorObra();
		coordFind.setAnoexp084(ab0484s00.getAnoexp084());
		coordFind.setTerexp084(ab0484s00.getTerexp084());
		coordFind.setNumexp084(ab0484s00.getNumexp084());
		coordFind.setTipdoc084(ab0484s00.getTipdoc084());
		coordFind.setNumdoc084(ab0484s00.getNumdoc084());
		coordFind.setIdape084(ab0484s00.getIdape084());
		coordFind.setCodobra084(ab0484s00.getCodobra084());
		coordFind.setTipcrd084(Constantes.COORDINADOR_ELABORACION_PROYECTO);

		List<CoordinadorObra> listaCoordinadores = this.coordinadorObra
				.findAll(coordFind, null);

		if (listaCoordinadores != null && !listaCoordinadores.isEmpty()) {
			errores.add(new ErrorField("aperturas.detalle.coordinadorP",
					"error.coordinadorP.activo"));

			if (!errores.isEmpty()) {
				throw new ErrorGenericoException(errores);
			}
		}

		try {
			ab0484s00.setTipcrd084(Constantes.COORDINADOR_ELABORACION_PROYECTO);
			ab0484s00Aux = this.coordinadorObra.add(ab0484s00);
		} catch (Exception e) {
			throw new ErrorGenericoException("");
		}
		CoordinadorObraController.logger
				.info("[PUT] : CoordinadorObra actualizado correctamente");
		return ab0484s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * ab0484s00 CoordinadorObra Bean que contiene la informacion con la que se
	 * va a crear el nuevo registro. request HttpServletRequest
	 *
	 * @param ab0484s00
	 *            the ab 0484 s 00
	 * @param request
	 *            the request CoordinadorObra Bean resultante del proceso de
	 *            creacion.
	 * @return the coordinador obra
	 */
	@RequestMapping(value = "coordinadorE", method = RequestMethod.POST)
	public @ResponseBody() CoordinadorObra addCoordinadorE(
			@RequestBody() CoordinadorObra ab0484s00,
			HttpServletRequest request) {

		CoordinadorObra ab0484s00Aux = new CoordinadorObra();

		HttpSession session = request.getSession();
		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null) {
				ab0484s00.setTerexp084(comunicAperturaSess.getTerape056());
				ab0484s00.setAnoexp084(comunicAperturaSess.getAnoape056());
				ab0484s00.setNumexp084(
						comunicAperturaSess.getNumape056().intValue());
				if (comunicAperturaSess.getCodobra056() != null) {
					ab0484s00
							.setCodobra084(comunicAperturaSess.getCodobra056());
				}
			}

		}

		// Validate
		List<ErrorField> errores = this.validateEditAdd(ab0484s00);
		if (errores != null && !errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// Mirar que ese coordinador no este asignado ya
		CoordinadorObra coordFind = new CoordinadorObra();
		coordFind.setAnoexp084(ab0484s00.getAnoexp084());
		coordFind.setTerexp084(ab0484s00.getTerexp084());
		coordFind.setNumexp084(ab0484s00.getNumexp084());
		coordFind.setTipdoc084(ab0484s00.getTipdoc084());
		coordFind.setNumdoc084(ab0484s00.getNumdoc084());
		coordFind.setIdape084(ab0484s00.getIdape084());
		coordFind.setCodobra084(ab0484s00.getCodobra084());
		coordFind.setTipcrd084(Constantes.COORDINADOR_EJECUCION_OBRA);

		List<CoordinadorObra> listaCoordinadores = this.coordinadorObra
				.findAll(coordFind, null);

		if (listaCoordinadores != null && !listaCoordinadores.isEmpty()) {
			errores.add(new ErrorField("aperturas.detalle.coordinadorP",
					"error.coordinadorE.activo"));

			if (!errores.isEmpty()) {
				throw new ErrorGenericoException(errores);
			}
		}

		try {
			ab0484s00.setTipcrd084(Constantes.COORDINADOR_EJECUCION_OBRA);
			ab0484s00Aux = this.coordinadorObra.add(ab0484s00);
		} catch (Exception e) {
			throw new ErrorGenericoException("");
		}
		CoordinadorObraController.logger
				.info("[PUT] : CoordinadorObra actualizado correctamente");
		return ab0484s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * terexp084 String anoexp084 String numexp084 Integer tipcrd084 String
	 * tipdoc084 String numdoc084 String fecalt084 Date Identificador del objeto
	 * que se desea eliminar.
	 *
	 * @param terexp084
	 *            the terexp 084
	 * @param anoexp084
	 *            the anoexp 084
	 * @param numexp084
	 *            the numexp 084
	 * @param tipcrd084
	 *            the tipcrd 084
	 * @param tipdoc084
	 *            the tipdoc 084
	 * @param numdoc084
	 *            the numdoc 084
	 * @param fecalt084
	 *            the fecalt 084 CoordinadorObra Bean eliminado.
	 * @return the coordinador obra
	 */
	@RequestMapping(value = "/{terexp084}/{anoexp084}/{numexp084}/{tipcrd084}/{tipdoc084}/{numdoc084}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() CoordinadorObra remove(
			@PathVariable() String terexp084, @PathVariable() String anoexp084,
			@PathVariable() Integer numexp084, @PathVariable() String tipcrd084,
			@PathVariable() String tipdoc084, @PathVariable() String numdoc084,
			@PathVariable() Date fecalt084) {
		CoordinadorObra ab0484s00 = new CoordinadorObra();
		ab0484s00.setTerexp084(terexp084);
		ab0484s00.setAnoexp084(anoexp084);
		ab0484s00.setNumexp084(numexp084);
		ab0484s00.setTipcrd084(tipcrd084);
		ab0484s00.setTipdoc084(tipdoc084);
		ab0484s00.setNumdoc084(numdoc084);
		ab0484s00.setFecalt084(fecalt084);
		this.coordinadorObra.remove(ab0484s00);
		CoordinadorObraController.logger
				.info("[DELETE] : CoordinadorObra borrado correctamente");
		return ab0484s00;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * terexp084 String anoexp084 String numexp084 Integer tipcrd084 String
	 * tipdoc084 String numdoc084 String
	 *
	 * @param terexp084
	 *            the terexp 084
	 * @param anoexp084
	 *            the anoexp 084
	 * @param numexp084
	 *            the numexp 084
	 * @param tipcrd084
	 *            the tipcrd 084
	 * @param tipdoc084
	 *            the tipdoc 084
	 * @param numdoc084
	 *            the numdoc 084 CoordinadorObra Bean eliminado.
	 * @return the coordinador obra
	 */
	@RequestMapping(value = "coordinadorP/{terexp084}/{anoexp084}/{numexp084}/{tipcrd084}/{tipdoc084}/{numdoc084}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() CoordinadorObra removeCoordinadorP(
			@PathVariable() String terexp084, @PathVariable() String anoexp084,
			@PathVariable() Integer numexp084, @PathVariable() String tipcrd084,
			@PathVariable() String tipdoc084,
			@PathVariable() String numdoc084) {
		CoordinadorObra ab0484s00 = new CoordinadorObra();
		ab0484s00.setTerexp084(terexp084);
		ab0484s00.setAnoexp084(anoexp084);
		ab0484s00.setNumexp084(numexp084);
		ab0484s00.setTipcrd084(Constantes.COORDINADOR_ELABORACION_PROYECTO);
		ab0484s00.setTipdoc084(tipdoc084);
		ab0484s00.setNumdoc084(numdoc084);
		this.coordinadorObra.remove(ab0484s00);
		CoordinadorObraController.logger
				.info("[DELETE] : CoordinadorObra borrado correctamente");
		return ab0484s00;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * terexp084 String anoexp084 String numexp084 Integer tipcrd084 String
	 * tipdoc084 String numdoc084 String
	 *
	 * @param terexp084
	 *            the terexp 084
	 * @param anoexp084
	 *            the anoexp 084
	 * @param numexp084
	 *            the numexp 084
	 * @param tipcrd084
	 *            the tipcrd 084
	 * @param tipdoc084
	 *            the tipdoc 084
	 * @param numdoc084
	 *            the numdoc 084 CoordinadorObra Bean eliminado.
	 * @return the coordinador obra
	 */
	@RequestMapping(value = "coordinadorE/{terexp084}/{anoexp084}/{numexp084}/{tipcrd084}/{tipdoc084}/{numdoc084}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() CoordinadorObra removeCoordinadorE(
			@PathVariable() String terexp084, @PathVariable() String anoexp084,
			@PathVariable() Integer numexp084, @PathVariable() String tipcrd084,
			@PathVariable() String tipdoc084,
			@PathVariable() String numdoc084) {
		CoordinadorObra ab0484s00 = new CoordinadorObra();
		ab0484s00.setTerexp084(terexp084);
		ab0484s00.setAnoexp084(anoexp084);
		ab0484s00.setNumexp084(numexp084);
		ab0484s00.setTipcrd084(Constantes.COORDINADOR_EJECUCION_OBRA);
		ab0484s00.setTipdoc084(tipdoc084);
		ab0484s00.setNumdoc084(numdoc084);
		this.coordinadorObra.remove(ab0484s00);
		CoordinadorObraController.logger
				.info("[DELETE] : CoordinadorObra borrado correctamente");
		return ab0484s00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model
	 *
	 * @param model
	 *            the model String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		CoordinadorObraController.logger.info("[GET - View] : ab0484s00");
		return "tabCoordinadores";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filterCoordinadorObra CoordinadorObra Bean que contiene los parametros de
	 * filtrado a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest
	 *
	 * @param filterCoordinadorObra
	 *            the filter coordinador obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request JQGridResponseDto<CoordinadorObra> Dto que
	 *            contiene el resultado del filtrado realizado por el componente
	 *            RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "coordinadorP/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<CoordinadorObra> filterP(
			@RequestJsonBody(param = "filter") CoordinadorObra filterCoordinadorObra,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request) {
		CoordinadorObraController.logger
				.info("[POST - filter] : Obtener CoordinadorObras");

		HttpSession session = request.getSession();

		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null) {
				filterCoordinadorObra
						.setAnoexp084(comunicAperturaSess.getAnoape056());
				filterCoordinadorObra
						.setTerexp084(comunicAperturaSess.getTerape056());
				filterCoordinadorObra.setNumexp084(
						comunicAperturaSess.getNumape056().intValue());
				filterCoordinadorObra
						.setCodobra084(comunicAperturaSess.getCodobra056());
			}

		}

		filterCoordinadorObra
				.setTipcrd084(Constantes.COORDINADOR_ELABORACION_PROYECTO);
		return this.coordinadorObra.filter(filterCoordinadorObra,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filterCoordinadorObra CoordinadorObra Bean que contiene los parametros de
	 * filtrado a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. request
	 * HttpServletRequest
	 *
	 * @param filterCoordinadorObra
	 *            the filter coordinador obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param request
	 *            the request JQGridResponseDto<CoordinadorObra> Dto que
	 *            contiene el resultado del filtrado realizado por el componente
	 *            RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "coordinadorE/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<CoordinadorObra> filterE(
			@RequestJsonBody(param = "filter") CoordinadorObra filterCoordinadorObra,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request) {
		CoordinadorObraController.logger
				.info("[POST - filter] : Obtener CoordinadorObras");

		HttpSession session = request.getSession();

		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null) {
				filterCoordinadorObra
						.setAnoexp084(comunicAperturaSess.getAnoape056());
				filterCoordinadorObra
						.setTerexp084(comunicAperturaSess.getTerape056());
				filterCoordinadorObra.setNumexp084(
						comunicAperturaSess.getNumape056().intValue());
				filterCoordinadorObra
						.setCodobra084(comunicAperturaSess.getCodobra056());
			}

		}

		filterCoordinadorObra
				.setTipcrd084(Constantes.COORDINADOR_EJECUCION_OBRA);
		return this.coordinadorObra.filter(filterCoordinadorObra,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filterCoordinadorObra CoordinadorObra Bean que contiene los parametros de
	 * filtrado a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterCoordinadorObra
	 *            the filter coordinador obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto JQGridResponseDto<CoordinadorObra> Dto
	 *            que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<CoordinadorObra> filter(
			@RequestJsonBody(param = "filter") CoordinadorObra filterCoordinadorObra,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		CoordinadorObraController.logger
				.info("[POST - filter] : Obtener CoordinadorObras");
		return this.coordinadorObra.filter(filterCoordinadorObra,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * filterCoordinadorObra CoordinadorObra Bean que contiene los parametros de
	 * filtrado a emplear. searchCoordinadorObra CoordinadorObra Bean que
	 * contiene los parametros de busqueda a emplear. jqGridRequestDto Dto que
	 * contiene los parametros de configuracion propios del RUP_TABLE a aplicar
	 * en la búsqueda.
	 *
	 * @param filterCoordinadorObra
	 *            the filter coordinador obra
	 * @param searchCoordinadorObra
	 *            the search coordinador obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto TableRowDto<CoordinadorObra> Dto que
	 *            contiene el resultado de la busqueda realizada por el
	 *            componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody() List<TableRowDto<CoordinadorObra>> search(
			@RequestJsonBody(param = "filter") CoordinadorObra filterCoordinadorObra,
			@RequestJsonBody(param = "search") CoordinadorObra searchCoordinadorObra,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		CoordinadorObraController.logger
				.info("[POST - search] : Buscar CoordinadorObras");
		return this.coordinadorObra.search(filterCoordinadorObra,
				searchCoordinadorObra, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 * filterCoordinadorObra CoordinadorObra Bean que contiene los parametros de
	 * filtrado a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterCoordinadorObra
	 *            the filter coordinador obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto List<String> Lista de los
	 *            identificadores de los registros eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<String> removeMultiple(
			@RequestJsonBody(param = "filter") CoordinadorObra filterCoordinadorObra,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		CoordinadorObraController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples CoordinadorObras");
		this.coordinadorObra.removeMultiple(filterCoordinadorObra,
				jqGridRequestDto, false);
		CoordinadorObraController.logger
				.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * filterCoordinadorObra CoordinadorObra Bean que contiene los parametros de
	 * filtrado a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterCoordinadorObra
	 *            the filter coordinador obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto JQGridResponseDto<JerarquiaDto
	 *            <CoordinadorObra>> Dto que contiene el resultado del filtrado
	 *            realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<CoordinadorObra>> jerarquia(
			@RequestJsonBody(param = "filter") CoordinadorObra filterCoordinadorObra,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		CoordinadorObraController.logger.info(
				"[POST - jerarquia] : Obtener CoordinadorObras jerarquia");
		return this.coordinadorObra.jerarquia(filterCoordinadorObra,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * filterCoordinadorObra CoordinadorObra Bean que contiene los parametros de
	 * filtrado a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterCoordinadorObra
	 *            the filter coordinador obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto JQGridResponseDto<JerarquiaDto
	 *            <CoordinadorObra>> Dto que contiene el resultado del filtrado
	 *            realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<CoordinadorObra>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") CoordinadorObra filterCoordinadorObra,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		CoordinadorObraController.logger.info(
				"[POST - jerarquia] : Obtener CoordinadorObras jerarquia - Hijos");
		return this.coordinadorObra.jerarquiaChildren(filterCoordinadorObra,
				jqGridRequestDto);
	}

	/**
	 * Buscar coordinador P.
	 * 
	 * tipoIdentif String numeroDocumento String
	 *
	 * @param tipoIdentif
	 *            the tipo identif
	 * @param numeroDocumento
	 *            the numero documento Ramas
	 * @return the coordinador obra
	 */
	@RequestMapping(value = "coordinadorP/buscarCoordinador", method = RequestMethod.GET)
	public @ResponseBody() CoordinadorObra buscarCoordinadorP(
			@RequestParam(value = "tipoIdentif") String tipoIdentif,
			@RequestParam(value = "numeroDocumento") String numeroDocumento) {
		CoordinadorObra coordFind = new CoordinadorObra();
		coordFind.setTipdoc084(tipoIdentif);
		coordFind.setNumdoc084(numeroDocumento);

		List<CoordinadorObra> listaCoordinadores = this.coordinadorObra
				.findCoordinadorMaxFecAlta(coordFind);

		if (listaCoordinadores != null && listaCoordinadores.size() > 0) {
			return listaCoordinadores.get(0);
		} else {

			throw new ErrorGenericoException("");
		}
	}

	/**
	 * Buscar coordinador E.
	 * 
	 * tipoIdentif String numeroDocumento String
	 *
	 * @param tipoIdentif
	 *            the tipo identif
	 * @param numeroDocumento
	 *            the numero documento Ramas
	 * @return the coordinador obra
	 */
	@RequestMapping(value = "coordinadorE/buscarCoordinador", method = RequestMethod.GET)
	public @ResponseBody() CoordinadorObra buscarCoordinadorE(
			@RequestParam(value = "tipoIdentif") String tipoIdentif,
			@RequestParam(value = "numeroDocumento") String numeroDocumento) {
		CoordinadorObra coordFind = new CoordinadorObra();
		coordFind.setTipdoc084(tipoIdentif);
		coordFind.setNumdoc084(numeroDocumento);

		List<CoordinadorObra> listaCoordinadores = this.coordinadorObra
				.findCoordinadorMaxFecAlta(coordFind);

		if (listaCoordinadores != null && listaCoordinadores.size() > 0) {
			return listaCoordinadores.get(0);
		} else {

			throw new ErrorGenericoException("");
		}
	}

	/**
	 * Validate edit add.
	 * 
	 * coordinador Proyectista
	 *
	 * @param coordinador
	 *            the coordinador List<ErrorField>
	 * @return the list
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity
	private List<ErrorField> validateEditAdd(CoordinadorObra coordinador) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();

		if (coordinador.getTipdoc084() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.tipoIdentif",
					"error.tipocifnif"));
		}
		if (coordinador.getNumdoc084() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"validacion.obligatorio"));

		} else if (coordinador.getNumdoc084() != null
				&& Constantes.TIPO_CIF.equals(coordinador.getTipdoc084())
				&& !ValidadorNifCifNie
						.isCifValido(coordinador.getNumdoc084())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.cif.incorrecto"));
		} else if (coordinador.getNumdoc084() != null
				&& Constantes.TIPO_NIF.equals(coordinador.getTipdoc084())
				&& !ValidadorNifCifNie
						.isNifValido(coordinador.getNumdoc084())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.nif.incorrecto"));
		} else if (coordinador.getNumdoc084() != null
				&& Constantes.TIPO_NIE.equals(coordinador.getTipdoc084())
				&& !ValidadorNifCifNie
						.isNifValido(coordinador.getNumdoc084())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.nie.incorrecto"));
		}

		if (coordinador.getPaiscrd084() != null && Constantes.ID_PAIS_ESPANA
				.equals(coordinador.getPaiscrd084())) {
			if (coordinador.getCodProvincia() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.provincia",
						"validacion.obligatorio"));
			}
			if (coordinador.getCodMunicipio() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.municipio",
						"validacion.obligatorio"));
			}
		} else {
			if (coordinador.getDmuncrd084() == null
					|| "".equals(coordinador.getDmuncrd084())) {
				errorFields
						.add(new ErrorField("aperturas.detalle.munipExtranjero",
								"validacion.obligatorio"));
			}
		}

		return errorFields;
	}
}
